/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;

/**
 * <p>
 * Test for Locale DomainObject
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class LocaleTest extends BaseTestCase {
    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/globalization/LocaleTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Session m_ssn;

    /**
     * Construct a LocaleTest with the specified name.
     *
     * @param name
     */
    public LocaleTest(String name) {
        super(name);
    }

    public void setUp() {
        try {
            m_ssn = SessionManager.getSession();
        } catch (Exception e) {
            e.printStackTrace(System.err);
            fail(e.getMessage());
        }
    }

    /**
     * Test persistence of Locale DomainObject.
     */
    public void testPersistence() throws Exception {
        String charsetName = "ISO-8859-1";
        String language = "es";
        String country = "CO";

        DataCollection charsets = m_ssn.retrieve("com.arsdigita.globalization.Charset");
        Filter f = charsets.addFilter("charset = :charset");
        f.set("charset", charsetName);

        Charset charset = null;
        if (charsets.next()) {
            charset = new Charset(charsets.getDataObject());
        } else {
            charset = new Charset();
            charset.setCharset(charsetName);
            charset.save();
        }

        if (charset == null)
            throw new IllegalStateException();

        // create a Locale object and save it to the database.
        Locale locale = new Locale();
        locale.setLanguage(language);
        locale.setCountry(country);
        locale.setDefaultCharset(charset);
        locale.save();

        OID localeOID = locale.getOID();

        // retrieve the Locale object we just created and make sure
        // all values are what we expect.
        try {
            locale = new Locale(localeOID);
        } catch (DataObjectNotFoundException e) {
            fail("the locale was not created properly or could not be retrieved");
        }

        assertEquals(
                     "language is not the same",
                     language,
                     locale.getLanguage()
                     );

        assertEquals(
                     "country is not the same",
                     country,
                     locale.getCountry()
                     );

        assertEquals(
                     "character set is not the same",
                     charset.getCharset(),
                     locale.getDefaultCharset().getCharset()
                     );
    }
}
