/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// The class we are testing
import com.arsdigita.formbuilder.PersistentSubmit;

// Interface of the class that we are testing
import com.arsdigita.formbuilder.PersistentComponentFactory;

import com.arsdigita.bebop.Component;

// The reference class
import com.arsdigita.bebop.form.Submit;


/**
 * Test the PersistentSubmit class with the test pattern defined in the
 * PersistentComponentTestCase.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentSubmitTest.java#7 $
 */
public class PersistentSubmitTest extends PersistentComponentTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentSubmitTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Properties of the submit
    private String m_htmlName = "submit_test_name";
    private String m_label = "Submit test label";

    /**
     * JUnit needs this constructor
     */
    public PersistentSubmitTest(String name) {
        super(name);
    }

    // *** Methods inherited from PersistentComponentTestCase

    /**
     * This method returns an instance of the appropriate factory.
     */
    protected PersistentComponentFactory createPrimaryPersistentFactory() {

        PersistentSubmit factory =
            PersistentSubmit.create(m_htmlName);

        factory.setDefaultValue(m_label);

        return factory;
    }

    /**
     * This method creates a new reference component and populates it with
     * test data
     */
    protected Component createPrimaryReferenceComponent() {

        Submit submit = new Submit(m_htmlName);

        submit.setButtonLabel(m_label);

        return submit;
    }

    // We do not override the checkPersistenceAttributes() method since we keep
    // no persistence specific attributes for the Submit
}
