/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.*;
import java.util.*;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

/**
 * Uses JavaPackage & JavaTest for domain testing.
 *
 * @author Jon Orris
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 */
public class DependencyTest extends DomainTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/domain/DependencyTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger log =
        Logger.getLogger(DependencyTest.class.getName());

    public DependencyTest(String name) {
        super(name);
    }

    protected void domainSetUp() {
        load("com/arsdigita/domain/examples/package.pdl");
        super.domainSetUp();
    }

    protected void domainTearDown() {
        // Return to original state.
        DomainObjectFactory.resetFactory();
        super.domainTearDown();
    }

    public void testNewInstance() throws Exception {

        String type = "com.arsdigita.domain.Package";
        DataObject object = getSession().create(type);
        DomainObjectFactory.registerInstantiator(type,
                                                 new JavaPackageInstantiator());

        JavaPackage p = null;
        try {
            p = (JavaPackage) DomainObjectFactory.newInstance(object);
        }
        catch(RuntimeException e) {
            fail("Should be able to make a newInstance for " + object.getObjectType());
        }

        assertNotNull(p);
        OID id = new OID(type, 1);
        try {

            p = (JavaPackage) DomainObjectFactory.newInstance(id);
        }
        catch(RuntimeException e) {
            fail("Should be able to make newInstance for " + id );
        }

        assertNotNull(p);
        log.info ("Package: " + p.getName());

        DomainCollection collection = p.getClasses();
        while (collection.next()) {
            JavaClass c = (JavaClass) collection.getDomainObject();
            log.info("Class name: " + c.getName());
            log.info("IsAbstract? " + c.isAbstract());
            log.info("Package: " + c.getPackage().getName());
        }

        log.info("Afferent packages!");

        collection = p.getAfferentPackages();
        while (collection.next()) {
            JavaPackage afferent = (JavaPackage) collection.getDomainObject();
            log.info(afferent.getName());
        }

        log.info("Efferent packages!");

        collection = p.getEfferentPackages();
        while (collection.next()) {
            JavaPackage afferent = (JavaPackage) collection.getDomainObject();
            log.info(afferent.getName());
        }

        log.info("Afferent Coupling: " + p.getAfferentCoupling());
        log.info("Efferent Coupling: " + p.getEfferentCoupling());
        log.info("Abstractness: " + p.getAbstractness());
        log.info("Instability: " + p.getInstability());
    }



    /*
     *  This test will fail miserably if testNewInstance fails because
     *  this assumes that it is possible to create a new instance
     */
    public void testAddingAssociation() {

        String type = "com.arsdigita.domain.Package";
        DataObject object = getSession().create(type);
        DomainObjectFactory.registerInstantiator(type,
                                                 new JavaPackageInstantiator());

        JavaPackage p = (JavaPackage) DomainObjectFactory.newInstance(object);
        p.set("id", new BigDecimal(400));
        p.setName("the name");
        p.save();

        DataAssociation association = (DataAssociation) p.get("used_by_set");

        DataObject object2 = getSession().create(type);

        JavaPackage p2 = (JavaPackage) DomainObjectFactory.newInstance(object2);
        p2.set("id", new BigDecimal(500));
        p2.setName("the name2");
        p2.save();


        // now, add something to the association
        p2.addToAssociation(association);

        p.save();
        p2.save();
        assertTrue(association.size() == 1);

    }

}
