/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dbinvariants;

import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;
import com.arsdigita.tools.junit.framework.PackageTestSuite;
import com.arsdigita.db.DbHelper;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestResult;

/**
 * @author Jon Orris
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class DBInvariantTestSuite extends PackageTestSuite {
    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/dbinvariants/DBInvariantTestSuite.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static Test suite() {
        DBInvariantTestSuite suite = new DBInvariantTestSuite();
        populateSuite(suite);
        BaseTestSetup wrapper = new DBTestSetup(suite);
        //wrapper.setInitScriptTarget ("com.arsdigita.db.Initializer");
        return wrapper;
    }

    private static class DBTestSetup extends CoreTestSetup {
        public DBTestSetup(TestSuite suite) {
            super(suite);
        }

        public void basicRun(TestResult testResult) {
            if (DbHelper.getDatabase() == DbHelper.DB_ORACLE) {
                super.basicRun(testResult);
            }
        }
    }

}
