/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.categorization;

import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.Session;

import junit.framework.TestCase;

// ALL METHODS ARE COMMENTED OUT BECAUSE WE ARE REPLACING THE API
// AND SO WE HAVE TO REWRITE MOST OF THE TESTS
/**
 * This performs some smoke tests on the CategoryTreeNode class
 * Specifically, it makes sure that every method works as
 * advertised and that the system talks to the database currectly
 *
 *
 * @author Randy Graebner
 * @version 1.0
 * @see com.arsdigita.kernel
 * @see com.arsdigita.categorization
 */


public class CategoryTreeNodeTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/categorization/CategoryTreeNodeTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    Session session;
    TransactionContext txn;

    /**
     * Constructs a CategoryTreeNodeTest with the specified name.
     *
     * @param name Test case name.
     **/
    public CategoryTreeNodeTest( String name ) {
        super( name );
    }

    public void setUp() {
        session = SessionManager.getSession();
        txn = session.getTransactionContext();
        txn.beginTxn();
    }

    public void tearDown() {
        txn.abortTxn();
    }


    public void testConstructors() {
    }

    /* TODO
       these are the methods to test
       public CategoryTreeNode(ACSObject c,
       boolean includeCategories,
       boolean includeObjects) {
       public Component getComponent() {
       public Iterator getChildren() {
       public boolean hasChildren() {
       public String getId() {
       public ACSObject getObject() {
       public String getLabel() {

    */
}
