/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.event.*;
import com.arsdigita.bebop.*;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.RequestEnvironment;

public class ValidationListenerTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/ValidationListenerTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */
    protected FormData _formData;
    protected ParameterModel _stringParameter;
    protected ParameterModel _numberParameter;
    protected FormModel _model;
    protected HttpServletDummyRequest _httpRequest;
    protected ParameterListener _validationListener;
    private RequestEnvironment m_env;

    public ValidationListenerTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */

    protected void setUp() {
        _stringParameter =  new StringParameter("StringParameter");
        _numberParameter =  new NumberParameter("NumberParameter");
        m_env = new RequestEnvironment();
        _httpRequest = m_env.getRequest();

        _model = new FormModel("Validation Test");

        try {
            _model.addFormParam(_stringParameter);
            _model.addFormParam(_numberParameter);
        } catch (Exception e) {
            fail("Exception in trying to add parameter model" + e.getMessage());
        }

    }

    protected void createFormData() {
        _model.lock();
        try {
            _formData = new FormData(_model, _httpRequest, true);
        } catch (FormProcessException fpe) {
            fail("Form Process Exception trying to create FormData " + fpe.getMessage());
        }
    }
    /**
       Tears down the text fixture.
       Called after every test case method.
    */

    protected void tearDown() {
        _formData=null;
        _stringParameter=null;
        _numberParameter=null;
        _model=null;
        _httpRequest=null;
        _validationListener=null;
    }

    public void testDummy() {
        // FIXME: Add tests for validation listeners
    }
}
