/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.*;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.HttpServletDummyRequest;

import java.lang.IllegalArgumentException;

public class URLParameterTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/URLParameterTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */

    protected ParameterModel _URLParameter;
    protected HttpServletDummyRequest _httpRequest;

    public URLParameterTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */

    protected void setUp() {
        _URLParameter =  new URLParameter("URLParameter");
        _httpRequest = new HttpServletDummyRequest();
    }

    /**
       Tears down the text fixture.
       Called after every test case method.
    */

    protected void tearDown() {
        _URLParameter=null;
        _httpRequest=null;
    }

    public void testURLParameterNoValues() {

        String[] specifiedValues = {};
        _httpRequest.setParameterValues("URLParameter",specifiedValues );
        assertEquals(_URLParameter.transformValue(_httpRequest),null);

    }

    public void testURLParameterGoodValue() {
        String[] specifiedValues = {"http://www.arsdigita.com"};
        _httpRequest.setParameterValues("URLParameter",specifiedValues );
        try {
            Object temp = _URLParameter.transformValue(_httpRequest);
            assertEquals(specifiedValues[0], temp.toString());
        } catch (IllegalArgumentException iae) {
            fail(iae.toString());
        }
    }


    public void testURLParameterGoodValueWithPath() {
        String[] specifiedValues = {"http://www.arsdigita.com/doc"};
        _httpRequest.setParameterValues("URLParameter",specifiedValues );
        try {
            Object temp = _URLParameter.transformValue(_httpRequest);
            assertEquals(specifiedValues[0], temp.toString());
        } catch (IllegalArgumentException iae) {
            fail(iae.toString());
        }
    }


    public void testURLParameterGoodValueWithoutProtocol() {
        String[] specifiedValues = {"www.arsdigita.com"};
        _httpRequest.setParameterValues("URLParameter",specifiedValues );
        try {
            Object temp = _URLParameter.transformValue(_httpRequest);
            assertEquals(specifiedValues[0], temp.toString());
        } catch (IllegalArgumentException iae) {
            fail(iae.toString());
        }
    }


    public void testURLParameterGoodValueNotFullyQualified() {
        String[] specifiedValues = {"ultrawoman.sf"};
        _httpRequest.setParameterValues("URLParameter",specifiedValues );
        try {
            Object temp = _URLParameter.transformValue(_httpRequest);
            assertEquals(specifiedValues[0], temp.toString());
        } catch (IllegalArgumentException iae) {
            fail(iae.toString());
        }
    }
}
