/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import junit.framework.*;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.TagTestElement;
import com.arsdigita.bebop.*;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.HttpServletDummyResponse;
import org.apache.log4j.Logger;

public class TagTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/form/TagTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public TagTest(String name) {
        super(name);
    }

    // http://developer.arsdigita.com/acs5/sdm/one-ticket?ticket_id=153343

    /** This is a simple white box test that verifies a BeBop
     *  component renders to the appropriate XML element.
     */

    // needs to be refactored to include a fixture and testing methods
    // for different widgets

    public void testCheckbox() throws javax.servlet.ServletException {

        Page p = new Page();
        ComponentTestHarness harness = new ComponentTestHarness(p);
        Element parent = new Element("test_parent");

        Widget w = new CheckboxGroup("check_test");
        w.generateWidget(harness.getPageState(), parent);

        java.util.List l = parent.getChildren();
        Element child = (Element) l.get(0);

        // need access to child's internals to verify
        // the right tag was generated.  hmm.
        // i have an idea -- maybe we can cheat!

        org.w3c.dom.Element e =
            TagTestElement.getInternalElementForTesting(child);
        assertEquals(e.getTagName(), w.getElementTag());
    }


}
