/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.*;
import junit.framework.TestCase;

public class OptionTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/form/OptionTest.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Option _option;

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */

    public OptionTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */
    protected void setUp() {
        _option = new Option("Value","Label");
    }

    /**
       Tears down the text fixture.
       Called after every test case method.
    */

    protected void tearDown() {
        _option = null;
    }

    public void testSetLabel() {
        String label = "New Label";
        _option.setLabel(label);
        assertTrue( label == _option.getLabel() );
    }


    public void testSetValue() {
        String value = "New Value";
        _option.setValue(value);
        assertTrue( value == _option.getValue() );
    }

    // We have changed the way that this works. This test needs to be
    // modified, or moved to OptionGroupTest.java (which doesn't exist
    // yet).

    //    public void testSetSelectedYes() {
    //      _option.setAttribute("selected","yes");
    //      assert( _option.isSelected() );
    //    }

    //    public void testSetSelectedTrue() {
    //      _option.setAttribute("selected","TRUE");
    //      assert( _option.isSelected() );
    //    }

    //    public void testSetSelectedFalse() {
    //      _option.setAttribute("selected","foo");
    //      assert( !(_option.isSelected()) );
    //    }
}
