/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;


/**
 * Regression tests for the Image component.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class ImageTest extends XMLComponentRegressionBase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/ImageTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public ImageTest (String id) {
        super(id);
    }

    /**
     *  Test an empty Image.
     */
    public void testEmptyImage() {
        testComponent(new Image("http://www.arsdigita.com/graphics/eyes-18a.jpg"),"empty");
    }

    /**
     *  Test an empty Image with an ALT tag.
     */
    public void testImageWithAlt() {
        testComponent(new Image("http://www.arsdigita.com/graphics/eyes-18a.jpg","The Eyes"),"with-alt");
    }

    /**
     *  Test ALT, but using the set method.
     */
    public void testImageAlt() {
        Image eyes = new Image("http://www.arsdigita.com/graphics/eyes-18a.jpg");
        eyes.setAlt("The Eyes");
        testComponent(eyes,"with-alt");
    }

    /**
     *  Test setHeight, setWidth, setBorder.
     */
    public void testImageWidthHeightBorder() {
        Image eyes = new Image("http://www.arsdigita.com/graphics/eyes-18a.jpg");
        eyes.setWidth("481");
        eyes.setHeight("118");
        eyes.setBorder("0");
        testComponent(eyes,"width-height-border");
    }

}
