/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import junit.framework.TestCase;

/**
 * Regression tests for the Container interface.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class ContainerTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/ContainerTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    ContainerImpl m_containerImpl;

    public ContainerTest (String id) {
        super(id);
        m_containerImpl = new ContainerImpl();
    }

    /**
     *
     * Tests to make sure the add(Component) method exists.
     */
    public void testAddWithComponent() {
        Label l = new Label("Hello");
        m_containerImpl.add(l);
    }

    /**
     *
     * Tests to make sure the add(Component, int) method exists.
     */
    public void testAddWithComponentConstraints() {
        Label l = new Label("Hello");
        m_containerImpl.add(l,1);
    }

    public void testContains() {
        Object o = new Object();
        boolean b = m_containerImpl.contains(o);
        assertTrue(b);
    }

    public void testGet() {
        Component c = m_containerImpl.get(0);
    }

    public void testIndexOf() {
        Label l = new Label("Hello");
        int i = m_containerImpl.indexOf(l);
    }

    public void testIsEmpty() {
        boolean b = m_containerImpl.isEmpty();
        assertTrue(b);
    }

    public void testSize() {
        int i = m_containerImpl.size();
    }
}
