/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;


/**
 * Regression tests for the BoxPanel component.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class BoxPanelTest extends XMLComponentRegressionBase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/BoxPanelTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public final static int HORIZONTAL = 1;
    public final static int VERTICAL = 2;

    public BoxPanelTest (String id) {
        super(id);
    }

    /**
     *  Test an empty BoxPanel
     */
    public void testEmptyBoxPanel() {
        testComponent(new BoxPanel(),"empty");
    }

    /**
     *  Test a horizontal BoxPanel
     */
    public void testHorizontalBoxPanel() {
        testComponent(new BoxPanel(HORIZONTAL),"horiz");
    }


    /**
     *  Test a vertical BoxPanel
     */
    public void testVerticalBoxPanel() {
        testComponent(new BoxPanel(VERTICAL),"vertical");
    }


    /**
     *  Test a horizontal BoxPanel with centering
     */
    public void testCenteredHorizontalBoxPanel() {
        testComponent(new BoxPanel(HORIZONTAL, true),"horiz-centered");
    }


    /**
     *  Test a vertical BoxPanel with centering
     */
    public void testCenteredVerticalBoxPanel() {
        testComponent(new BoxPanel(VERTICAL, true),"vertical-centered");
    }


}
