/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.xmlinterp;

import org.w3c.dom.Node;

/**
 * <p>The XMLInterpreter interface allows an arbitrary class to obtain tokens to
 * interpret at part of a simple language framework. There are three events:
 * shift, reduce, and push. The semantics of the interpreter are described in
 * the documentation for XMLWalker.</p>
 *
 * <p>No exceptions are thrown as part of the interface, and no consistent way
 * to get errors is provided. The implementor is expected to cache error
 * information locally and provide it with a getError method.</p>
 *
 * <p>To use this interface, create a DOM with Xerces, using the
 * DocumentBuilderFactory to construct a DocumentBuilder. Use parse to return
 * the new DOM.</p>
 *
 * <p>Instantiate an object that implements XMLInterpreter, then pass is to
 * XMLWalker.walk().  Use additional methods in the imterpreter class to pass
 * state and error information.</p>
 *
 * @author Bryan Che (bche@redhat.com)
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 * @since CCM Core 5.2
 *
 */

public interface XMLInterpreter {
    void shift(String s, String v);

    void reduce(String s);

    void push(Node n);
}
