/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;

/**
 * WorkflowConfig
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

public final class WorkflowConfig extends AbstractConfig {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/WorkflowConfig.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private BooleanParameter m_alerts = new BooleanParameter
        ("waf.workflow.simple.alerts_enabled", Parameter.OPTIONAL,
         Boolean.TRUE);

    private StringParameter m_sender = new StringParameter
        ("waf.workflow.simple.alerts_sender", Parameter.OPTIONAL, null);

    public WorkflowConfig() {
        register(m_alerts);
        register(m_sender);
        loadInfo();
    }

    public boolean isAlertsEnabled() {
        return get(m_alerts).equals(Boolean.TRUE);
    }

    public String getAlertsSender() {
        return (String) get(m_sender);
    }

}
