/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.webdevsupport.log4j;

import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.parameters.StringParameter;

/**
 * Log4j category level form
 *
 *
 * Created: Mon Jul 29 14:01:52 2002
 *
 * @author Daniel Berrange
 */

public class CategoryForm extends Form {

    private TextField m_category;
    private SingleSelect m_level;

    public CategoryForm() {
        super("log4j");

        m_category = new TextField(new StringParameter("category"));
        m_category.setSize(40);
        add(new Label("Logger:"));
        add(m_category);

        m_level = new SingleSelect(new StringParameter("level"));
        m_level.addOption(new Option("DEBUG", "Debug"));
        m_level.addOption(new Option("INFO", "Info"));
        m_level.addOption(new Option("WARN", "Warn"));
        m_level.addOption(new Option("ERROR", "Error"));
        m_level.addOption(new Option("FATAL", "Fatal"));
        add(new Label("Level:"));
        add(m_level);

        add(new Submit("Update"));
    }


    public void setLogger(PageState state,
                          String cat) {
        m_category.setValue(state, cat);
    }

    public String getLogger(PageState state) {
        return (String)m_category.getValue(state);
    }

    public void setLevel(PageState state,
                         String level) {
        m_level.setValue(state, level);
    }

    public String getLevel(PageState state) {
        return (String)m_level.getValue(state);
    }
}
