/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.webdevsupport;

//imports here

/**
 *
 * @author Joseph A. Bank (jbank@alum.mit.edu)
 * @version 1.0
 **/
public class StageInfo {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/StageInfo.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_name;
    private long m_start_time;
    private long m_end_time;
    private int m_depth;
    private int m_start_queries;
    private int m_end_queries;
    private boolean m_leaf = true;
    public StageInfo(String name, int depth, int start_queries) {
        m_name = name;
        m_depth = depth;
        m_start_time = System.currentTimeMillis();
        m_start_queries = start_queries;
    }
    public String getName() {
        return m_name;
    }
    public void end(int end_queries) {
        m_end_time = System.currentTimeMillis();
        m_end_queries = end_queries;
    }
    public long endTime() {
        return m_end_time;
    }
    public long startTime() {
        return m_start_time;
    }
    public long time() {
        return m_end_time-m_start_time;
    }
    public int depth() {
        return m_depth;
    }
    public void setLeaf(boolean leaf) {
        m_leaf = leaf;
    }
    public boolean leaf() {
        return m_leaf;
    }
    public int numQueries() {
        return m_end_queries - m_start_queries;
    }
    public long queryTime(java.util.ListIterator queries) {
        long total_time = 0;
        int i = 0;
        while (queries.hasNext() && i!=m_start_queries) {
            queries.next();
            i++;
        }
        while (queries.hasNext() && i!=m_end_queries) {
            QueryInfo qi = (QueryInfo)queries.next();
            total_time += qi.getTime();
            i++;
        }
        return total_time;
    }
}
