/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.Sequences;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

/**
 *
 * @author Aram Kananov (akananov@redhat.com)
 * @version 1.0
 **/

public class QueryPlan {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/QueryPlan.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(QueryPlan.class);

    public static boolean planTableExists() {
        Session session = SessionManager.getSession();
        DataQuery query =
            session.retrieveQuery(
                                  "com.arsdigita.webdevsupport.planTableExists"
                                  );
        return query.size() == 1;
    }


    public static String getQueryPlanID(String sqlText) {
        String planID = getNewQueryPlanID();
        generateQueryPlan (sqlText, planID);
        return planID;
    }


    public static void deleteQueryPlan(String planID) {
        DataOperation operation =
            SessionManager.getSession().retrieveDataOperation(
                                                              "com.arsdigita.webdevsupport.deleteQueryPlan"
                                                              );
        operation.setParameter("planID", planID);
        operation.execute();
    }

    private static  void generateQueryPlan(String sqlText, String planID) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getCurrentThreadConnection();
            stmt = conn.createStatement();
            stmt.executeUpdate
                ("explain plan set statement_id = '" + planID +
                 "' for " + sqlText);
        } catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        } finally {
            try {
                if (stmt != null) { stmt.close(); }
            } catch (SQLException e2) {
                throw new UncheckedWrapperException(e2);
            }
        }
    }

    private static String getNewQueryPlanID () {
        try {
            return "ACS-query-"+ Sequences.getNextValue();
        } catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

}
