/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;
import org.apache.log4j.Logger;

/**
 * <p>A base servlet for use by JSP authors who want to use the
 * execution environment that <code>BaseServlet</code> provides.  A
 * JSP will use this class if the extends attribute of the page
 * declaration is set to this class, as in this example:</p>
 *
 * <blockquote><pre>
 * <%@page extends="com.arsdigita.web.BaseJSP" %>
 * <b><%= Web.getContext().getUser().toString() %></b>
 * </pre></blockquote>
 *
 * @see com.arsdigita.web.BaseServlet
 * @author Justin Ross &lt;<a href="mailto:jross@redhat.com">jross@redhat.com</a>&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/BaseJSP.java#10 $
 */
public abstract class BaseJSP extends BaseServlet implements HttpJspPage {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/BaseJSP.java#10 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(BaseJSP.class);

    /**
     * <p>Invokes the <code>_jspService(sreq, sresp)</code> method in
     * the environment prepared by <code>BaseServlet</code>.</p>
     *
     * @see #_jspService(HttpServletRequest,HttpServletResponse)
     * @see com.arsdigita.web.BaseServlet
     * @see com.arsdigita.web.BaseServlet#doService(HttpServletRequest,HttpServletResponse)
     */
    protected final void doService(final HttpServletRequest sreq,
                                   final HttpServletResponse sresp)
            throws ServletException, IOException {
        // The exception handling that Tomcat and Resin JSP compilers
        // use wraps runtime exceptions and errors in
        // ServletExceptions.  We unwrap them here so that BaseServlet
        // can avoid doing contortions for JSPs.

        try {
            _jspService(sreq, sresp);
        } catch (ServletException se) {
            final Throwable cause = se.getRootCause();

            if (cause instanceof Error) {
                // It is necessary to cast these because the Java
                // compiler complains about Throwables that are not
                // declared or caught.

                throw (Error) cause;
            } else if (cause instanceof RuntimeException) {
                throw (RuntimeException) cause;
            } else {
                throw se;
            }
        }
    }

    /**
     * <p>The method that JSP compilers will override to produce the
     * body of the page.</p>
     *
     * @see javax.servlet.jsp.HttpJspPage#_jspService(HttpServletRequest,HttpServletResponse)
     */
    public abstract void _jspService(HttpServletRequest sreq,
                                     HttpServletResponse sresp)
            throws ServletException, IOException;

  public void jspInit()
  {
  }

  public void jspDestroy()
  {
  }

}
