/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterChain;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;

import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.runtime.Startup;
import com.arsdigita.web.Web;

import org.apache.log4j.Logger;


/**
 * A base class for filters that require a persistence
 * session to be present. This implements the doFilter
 * method to open up a default persistence session, and
 * then hand off to the doService method. Subclasses 
 * should override this doService method to provide the 
 * processing they require. 
 */
public class BaseFilter implements Filter {

    private static Logger s_log = Logger.getLogger(BaseFilter.class);

    static {
        Startup startup = new Startup();
        if ( !startup.hasRun() ) {
            startup.run();
        }
    }

    public final void init(final FilterConfig sconfig) throws ServletException {
        if (s_log.isInfoEnabled()) {
            s_log.info("Initializing filter " + sconfig.getFilterName() +
                       " (class: " + getClass().getName() + ")");
        }

        doInit();
    }

    protected void doInit() throws ServletException {
        // Empty
    }

    public final void destroy() {
        if (s_log.isInfoEnabled()) {
            s_log.info
                ("Destroying filter " + getClass().getName());
        }

        doDestroy();
    }

    protected void doDestroy() {
        // Empty
    }

    public void doFilter(ServletRequest sreq,
                         ServletResponse sresp,
                         FilterChain chain)
        throws java.io.IOException,
               ServletException {

        if (s_log.isInfoEnabled()) {
            s_log.info("Filtering request " + sreq);
        }

        doService((HttpServletRequest)sreq,
                  (HttpServletResponse)sresp,
                  chain);
    }

    /**
     * This is the extension point for users of this class.
     */
    protected void doService(final HttpServletRequest sreq,
                             final HttpServletResponse sresp,
                             final FilterChain chain)
            throws ServletException, IOException {
        // Empty
    }
}
