/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.domain.DomainQuery;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.OID;

// merged versioning

/**
 * TagCollection
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

public class TagCollection extends DomainQuery {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/versioning/TagCollection.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    static final String TAGGED = "taggedOID";
    static final String DESC = "tag";

    private DataCollection m_tags;

    TagCollection(DataCollection tags) {
        super(tags);
        m_tags = tags;
    }

    public Tag getTag() {
        return new Tag((OID) Adapter.deserialize((String) m_tags.get(TAGGED),
                                                 Types.OID),
                       (String) m_tags.get(DESC));
    }

}
