/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.AbstractSingleSelectionModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.web.Web;
import com.arsdigita.kernel.security.UserContext;

/**
 * A SingleSelectionModel that returns the user id.
 *
 * @author Phong Nguyen
 * @author Sameer Ajmani
 * @version 1.0
 */
public class UserSingleSelectionModel extends AbstractSingleSelectionModel {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserSingleSelectionModel.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final String s_userIdName = "userId";
    private BigDecimalParameter m_parameter;

    public UserSingleSelectionModel() {
        super();
        m_parameter = new BigDecimalParameter(s_userIdName);
    }

    public Object getSelectedKey(PageState state) {
        UserContext ctx = Web.getUserContext();

        if (ctx.isLoggedIn()) {
            return ctx.getUserID();
        }

        return null;
    }

    public void setSelectedKey(PageState state, Object key) {
        // TODO:
    }

    public ParameterModel getStateParameter() {
        return m_parameter;
    }
}
