/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.kernel.security.Initializer;

/**
 * Package-private class that generates the URL for a link dynamically from
 * the kernel page map.  This class will be removed or changes when the page
 * map is replaced by package parameters.
 *
 * @author Sameer Ajmani
 **/
class DynamicLink extends Link {
    public static final String versionId = 
        "$Id: //core-platform/dev/src/com/arsdigita/ui/login/DynamicLink.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    DynamicLink(final String labelKey, final String targetKey) {
        super(new Label(LoginHelper.getMessage(labelKey)),
              new PrintListener() {
                  public void prepare(PrintEvent e) {
                      Link link = (Link) e.getTarget();

                      String url = Initializer.getFullURL
                          (targetKey, e.getPageState().getRequest());

                      link.setTarget(url);
                  }
              });
    }
}
