/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.Label;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;
import java.math.BigDecimal;

/**
 * A label that initializes itself to the user's full name.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/UserNameLabel.java#8 $
 */

public class UserNameLabel extends Label {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/UserNameLabel.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public UserNameLabel() {

        super();

        PrintListener p = new PrintListener() {
                public void prepare (PrintEvent e) {
                    PageState s = e.getPageState();

                    Label t = (Label) e.getTarget();

                    User user;
                    try {
                        BigDecimal id = (BigDecimal) s.getGlobalValue("user_id");
                        user = User.retrieve(id);
                        t.setLabel(user.getName());
                    } catch (DataObjectNotFoundException ex) {
                        t.setLabel("");
                    }
                }
            };

        addPrintListener(p);
    }
}
