/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

/**
 * Form used to edit the information for a user.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/UserEditForm.java#9 $
 */

class UserEditForm extends UserForm
    implements FormInitListener,
               FormProcessListener,
               AdminConstants
{
    // Logging

    private static final Logger s_log =
        Logger.getLogger(UserEditForm.class.getName());

    private UserBrowsePane m_browsePane;

    /**
     * Constructor
     */

    public UserEditForm(UserBrowsePane browsePane) {
        super(USER_FORM_EDIT);
        m_browsePane = browsePane;

        addInitListener(this);
        addProcessListener(this);
    }

    /**
     * Initialize the form
     */

    public void init(FormSectionEvent e) {

        PageState state = e.getPageState();

        hideSecurityInfo(state);

        User user = m_browsePane.getUser(state);

        PersonName name = user.getPersonName();
        m_firstName.setValue(state, name.getGivenName());
        m_lastName.setValue(state, name.getFamilyName());

        m_primaryEmail.setValue(state, user.getPrimaryEmail().toString());

        if (user.getURI() != null && !user.getURI().equals("")) {
            m_url.setValue(state, user.getURI());
        }

        m_screenName.setValue(state, user.getScreenName());

        USER_FORM_LABEL_ADDITIONAL_EMAIL_LIST.setVisible(state, true);
        m_emailList.setVisible(state, true);
    }


    /**
     * Process the form
     */

    public void process (FormSectionEvent e)
        throws FormProcessException
    {
        PageState state = e.getPageState();

        User user = m_browsePane.getUser(state);

        PersonName name = user.getPersonName();
        name.setGivenName((String) m_firstName.getValue(state));
        name.setFamilyName((String) m_lastName.getValue(state));

        // Check to see if the value has changed from the default.  If
        // not just leave this set to null.

        String uri = (String) m_url.getValue(state);
        if (!uri.equals(USER_FORM_INPUT_URL_DEFAULT) && !uri.equals("")) {
            user.setURI(uri);
        }

        user.setScreenName((String) m_screenName.getValue(state));

        InternetAddress additional =
            (InternetAddress) m_additionalEmail.getValue(state);
        if (additional != null) {
            user.addEmailAddress
                (new EmailAddress(additional.getAddress()));
        }

        // Check to see if the primary email address has changed, and
        // if so set it to the new value and delete the association
        // with the old.  If it hasn't change don't do anything.

        EmailAddress oaddr = user.getPrimaryEmail();
        EmailAddress naddr = new EmailAddress(m_primaryEmail.getValue(state).toString());

        if (!oaddr.equals(naddr)) {
            user.setPrimaryEmail(naddr);
            user.save();
            user.removeEmailAddress(oaddr);
        }

        user.save();

        m_browsePane.displayUserInfoPanel(state);
    }
}
