/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.bebop.list.ListModel;


class PartyListModel implements ListModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/PartyListModel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private PartyCollection m_parties;
    private Party m_currentParty = null;

    /**
     * Constructor for the list
     * Builds the list of party list model for parties
     *
     * @param partys the partyCollection
     **/
    public PartyListModel(PartyCollection parties) {
        m_parties = parties;
    }

    /**
     * Check whether is an another party
     *
     * @return true if another party exist, false otherwise
     **/
    public boolean next() {
        if (m_parties.next()) {
            m_currentParty = m_parties.getParty();
            return true;
        }
        return false;
    }

    /**
     * Returns the unqiue ID string for current Party
     *
     * @return the unqiue ID string for current Party
     **/
    public String getKey() {
        return m_currentParty.getID().toString();
    }

    /**
     * Returns the current Party
     *
     * @return the current Party
     **/
    public Object getElement() {
        return m_currentParty.getName();
    }
}
