/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.EmailAddress;

final class GroupInfo extends SimpleComponent
    implements AdminConstants
{

    private GroupAdministrationTab m_parent;

    public GroupInfo(GroupAdministrationTab parent) {
        m_parent = parent;
    }

    public void generateXML(PageState state, Element parent) {

        Element elmt = new Element("admin:groupInfo", ADMIN_XML_NS);

        BigDecimal id = (BigDecimal) state.getValue(GROUP_ID_PARAM);

        if (id == null) {
            return;
        }

        Group group = m_parent.getGroup(state);

        if (group == null) {
            elmt.addAttribute("name", "Group #" + id + " not found");
            return;
        }

        elmt.addAttribute("id", group.getID().toString());
        elmt.addAttribute("name", group.getName());

        // Primary email is optional

        EmailAddress email = group.getPrimaryEmail();
        elmt.addAttribute
            ("email", email != null ? email.toString() : "");

        parent.addContent(elmt);
    }
}
