/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;


import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.ColumnPanel;

/**
 * Base form for add/edit group.
 *
 * @author David Dao
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupForm.java#7 $
 */
class GroupForm extends Form implements AdminConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupForm.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected TextField m_name;
    protected TextField m_email;

    public GroupForm(String formName) {
        super(formName);

        m_name = new TextField(new StringParameter(GROUP_FORM_INPUT_NAME));
        m_name.setMaxLength(200);
        m_name.addValidationListener(new NotEmptyValidationListener());
        m_name.addValidationListener(new StringLengthValidationListener (200));


        add(GROUP_FORM_LABEL_NAME);
        add(m_name);

        m_email = new TextField(new EmailParameter(GROUP_FORM_INPUT_PRIMARY_EMAIL));
        m_email.setMaxLength(100);
        add(GROUP_FORM_LABEL_PRIMARY_EMAIL);
        add(m_email);

        // Submit button
        add(new Submit(GROUP_FORM_SUBMIT), ColumnPanel.CENTER |
            ColumnPanel.FULL_WIDTH);
    }
}
