/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Tree;

import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;

import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Group;

import java.math.BigDecimal;

import javax.mail.internet.InternetAddress;

/**
 * Add group form.
 *
 * @author David Dao
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupAddForm.java#7 $
 */
class GroupAddForm extends GroupForm implements AdminConstants,
                                                FormProcessListener {

    private Tree m_groupTree;
    private GroupAdministrationTab m_groupTab;

    public GroupAddForm(Tree groupTree, GroupAdministrationTab tab) {
        super(GROUP_FORM_ADD);
        addProcessListener(this);
        m_groupTree = groupTree;
        m_groupTab = tab;
    }

    /**
     * Processes the form.
     */
    public void process(FormSectionEvent e)
        throws FormProcessException {

        PageState ps = e.getPageState();

        // Get super parent group.
        String key = (String) m_groupTree.getSelectedKey(ps);

        Group parentGroup = null;
        if (key != null) {
            BigDecimal parentID = new BigDecimal(key);

            try {
                parentGroup = new Group(parentID);
            } catch (DataObjectNotFoundException exc) {
                // Parent group does not exist.
                // This is normal behavior with the new group
                // been add with no parent.

            }
        }

        Group group = new Group();

        String name = (String) m_name.getValue(ps);
        group.setName(name);

        // Workaround for bug #189720: there is no way to remove a
        // Party's primary email address, so we set it directly to
        // null if it's value on the form is null.

        InternetAddress email = (InternetAddress) m_email.getValue(ps);
        if (email != null) {
            group.setPrimaryEmail(new EmailAddress(email.getAddress()));
        } else {
            //group.set("primaryEmail", null);
            group.setPrimaryEmail(null);
        }

        group.save();

        if (parentGroup != null) {
            parentGroup.addSubgroup(group);
            parentGroup.save();
        }

        if (m_groupTab != null) {
            m_groupTab.setGroup (ps, group);
        }
    }

}
