/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;


import com.arsdigita.ui.util.GlobalizationUtil ; 

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 * Dispatcher for Admin functionality
 *
 * @author David Dao 
 * @author Ron Henderson 
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/AdminDispatcher.java#10 $
 */

public class AdminDispatcher extends SubsiteDispatcher
    implements AdminConstants
{
    /**
     * Constructor.  Instantiates the subsite url/page mapping.
     */

    public AdminDispatcher() {
        addPage("", buildAdminIndexPage(), true);
        addPage("denied", buildDeniedPage());
    }

    /**
     * Generic "Access Denied" page for the admin section.  This can
     * be customized by editing the admin stylesheet.
     */
    private Page buildDeniedPage() {
        Page p = PageFactory.buildPage("admin", new Label(new GlobalizedMessage
                                                          ("ui.admin.dispatcher.accessDenied", BUNDLE_NAME)));

        Label label = new Label(GlobalizationUtil.globalize("ui.admin.access_denied"));
        label.setClassAttr("AccessDenied");
        p.add(label);

        p.lock();

        return p;
    }

    /**
     * Index page for the admin section
     */
    private Page buildAdminIndexPage() {

        Page p = PageFactory.buildPage("admin", PAGE_TITLE_LABEL);

        p.addGlobalStateParam(USER_ID_PARAM);
        p.addGlobalStateParam(GROUP_ID_PARAM);

        /**
         * Create User split panel.
         */
        AdminSplitPanel userSplitPanel =
            new AdminSplitPanel(USER_NAVBAR_TITLE);

        UserBrowsePane browsePane = new UserBrowsePane();

        userSplitPanel.addTab(USER_TAB_SUMMARY,
                              new UserSummaryPane(userSplitPanel, browsePane));
        userSplitPanel.addTab(USER_TAB_BROWSE,
                              browsePane);
        userSplitPanel.addTab(USER_TAB_SEARCH,
                              new UserSearchPane(userSplitPanel, browsePane));
        userSplitPanel.addTab(USER_TAB_CREATE_USER,
                              new CreateUserPane(userSplitPanel));

        /**
         * Create main administration tab.
         */
        GroupAdministrationTab groupAdministrationTab = new GroupAdministrationTab();
        TabbedPane tb = new TabbedPane();
        tb.setIdAttr("page-body");

        tb.addTab(USER_TAB_TITLE, userSplitPanel);
        tb.addTab(GROUP_TAB_TITLE, groupAdministrationTab);

        browsePane.setTabbedPane(tb);
        browsePane.setGroupAdministrationTab(groupAdministrationTab);

        p.add(tb);
        p.lock();

        return p;
    }
}
