/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.ApplicationType;

import org.apache.log4j.Logger;

/**
 * Site wide admin application. Currently a trivial
 * subclass of com.arsdigita.web.Application
 * @see com.arsdigita.web.Application
 */
public class Admin extends Application {

    private static final Logger s_log = Logger.getLogger(Admin.class);

    public static final String BASE_DATA_OBJECT_TYPE
        = "com.arsdigita.ui.admin.Admin";

    public Admin(DataObject obj) {
        super(obj);
    }

    public Admin(OID oid)
        throws DataObjectNotFoundException {

        super(oid);
    }

    /**
     * Returns an instance of the Admin application.  May return null.
     **/
    public static Application getInstance() {
        ApplicationType adminType = ApplicationType.
            retrieveApplicationTypeForApplication(BASE_DATA_OBJECT_TYPE);
        if ( adminType == null ) { return null; }

        ApplicationCollection apps = Application.retrieveAllApplications();
        apps.addEqualsFilter("resourceType.id", adminType.getID());
        if ( !apps.next() ) { return null; }

        Application result = apps.getApplication();
        apps.close();
        return result;
    }
}
