/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/**
 * <p>A context bar.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/PropertyList.java#7 $
 */
public abstract class PropertyList extends SimpleComponent {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/PropertyList.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(PropertyList.class);

    private static final RequestLocal s_props = new RequestLocal() {
            protected final Object initialValue(final PageState state) {
                return new ArrayList();
            }
        };

    public PropertyList() {
        super();
    }

    protected List properties(final PageState state) {
        return (List) s_props.get(state);
    }

    public final void generateXML(final PageState state, final Element parent) {
        if (isVisible(state)) {
            final Element nav = parent.newChildElement
                ("bebop:propertyList", BEBOP_XML_NS);

            for (Iterator iter = properties(state).iterator();
                 iter.hasNext(); ) {
                ((Property) iter.next()).generateXML(state, nav);
            }
        }
    }

    public static final class Property {
        private final String m_title;
        private final String m_value;

        public Property(final String title, final String value) {
            super();

            Assert.assertNotNull(title, "String title");

            m_title = title;
            m_value = value;
        }

        public Property(final GlobalizedMessage title, final String value) {
            this(title.localize().toString(), value);
        }

        public Property(final GlobalizedMessage title,
                        final GlobalizedMessage value) {
            this(title.localize().toString(), value.localize().toString());
        }

        public Property(final String title, final GlobalizedMessage value) {
            this(title, value.localize().toString());
        }

        public void generateXML(final PageState state,
                                final Element parent) {
            final Element elem = parent.newChildElement
                ("bebop:property", BEBOP_XML_NS);

            elem.addAttribute("title", m_title);
            elem.addAttribute("value", m_value);
        }
    }
}
