/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

/**
 * <p>A simple layout panel with top, bottom, left, right, and body
 * sections.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/LayoutPanel.java#8 $
 */
public class LayoutPanel extends ComponentMap {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/LayoutPanel.java#8 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(LayoutPanel.class);

    public final void setTop(final Component top) {
        put("top", top);
    }

    public final void setLeft(final Component left) {
        put("left", left);
    }

    public final void setBody(final Component body) {
        put("body", body);
    }

    public final void setRight(final Component right) {
        put("right", right);
    }

    public final void setBottom(final Component bottom) {
        put("bottom", bottom);
    }

    public final void generateXML(final PageState state, final Element parent) {
        if (isVisible(state)) {
            final Element layout = parent.newChildElement
                ("bebop:layoutPanel", BEBOP_XML_NS);

            section(state, layout, "top");
            section(state, layout, "left");
            section(state, layout, "body");
            section(state, layout, "right");
            section(state, layout, "bottom");
        }
    }

    private void section(final PageState state,
                         final Element parent,
                         final String key) {
        final Component section = get(key);

        if (section != null) {
            final Element elem = parent.newChildElement
                ("bebop:" + key, BEBOP_XML_NS);

            section.generateXML(state, elem);
        }
    }
}
