/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;
import java.util.Iterator;

/**
 * 
 *
 * @author Justin Ross
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ItemDetail.java#9 $
 */
public class ItemDetail extends SimpleComponent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ItemDetail.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private ItemDetailModelBuilder m_builder;

    public ItemDetail(ItemDetailModelBuilder builder) {
        m_builder = builder;
    }

    public void generateXML(PageState pageState, Element parent) {
        ItemDetailModel model = m_builder.buildModel(pageState);

        Element itemDetail = new Element
            ("bebop:itemDetail", Component.BEBOP_XML_NS);
        parent.addContent(itemDetail);
        itemDetail.addAttribute("title", model.getTitle(pageState));

        generatePropertyXML(pageState, itemDetail, model);

        generateActionXML(pageState, itemDetail, model);
    }

    private void generatePropertyXML(PageState pageState, Element parent,
                                     ItemDetailModel model) {
        Iterator iter = model.getProperties(pageState);

        while (iter.hasNext()) {
            ItemDetailProperty property = (ItemDetailProperty)iter.next();
            property.generateXML(pageState, parent);
        }
    }

    private void generateActionXML(PageState pageState, Element parent,
                                   ItemDetailModel model) {
        Iterator iter = model.getActions(pageState);

        while (iter.hasNext()) {
            ItemDetailAction action = (ItemDetailAction)iter.next();
            action.generateXML(pageState, parent);
        }
    }
}
