/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.util.Lockable;
import com.arsdigita.bebop.PageState;

import com.arsdigita.persistence.DataQuery;

/**
 * This class is used by the {@link DataTable} class in order to
 * construct a {@link com.arsdigita.persistence.DataCollection} during
 * each request
 */
public interface DataQueryBuilder extends Lockable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DataQueryBuilder.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Perform all neccessary database operations and return
     * a {@link DataQuery} for the {@link DataTable} to use
     *
     * @param t the parent DataTable
     * @param s the page state
     */
    DataQuery makeDataQuery(DataTable t, PageState s);

    /**
     * @return the name of the column in the query that serves
     *   as the primary key for the items
     */
    String getKeyColumn();
}
