/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.SimpleContainer;
/**
 * This class provides a base for all ControlBar forms within the
 * system.  That is, it provides a base class so that the styling of
 * all control bars can be altered.
 *
 * @author <a href="mailto:randyg@alum.mit.edu">randyg@alum.mit.edu</a>
 * @version $Revision: #8 $ $Date: 2004/04/07 $ */
public class ControlBar extends Form {

    private SimpleContainer m_controlBar;

    /**
     * Constructs a new ControlBar with the specified name.  At the
     * time of creation, instantiates a new form model for the form
     * and instantiates a ColumnPanel as the default to contain the
     * components.
     *
     * @param name the name of the form
     * @param dimensions the number of dimensional sliders you want */
    public ControlBar(String name) {
        super(name, new SimpleContainer());
        m_controlBar = new SimpleContainer("bebop:controlBar", "http://www.arsdigita.com/bebop/1.0");
        add(m_controlBar);
    }

    public ControlBar(String name, Container controlBar) {
        super(name, controlBar);
        initialize();
    }

    /**
     *  This sets up information for this particular class.
     */
    private void initialize() {
        setClassAttr("controlBar");
    }

    /**
     *  Add a dimension bar to the control bar
     */
    public void addDimensionBar(DimensionBar dimbar) {
        // Right now, this does the same as addComponent(c).
        m_controlBar.add(dimbar);
    }

    public void addComponent(Component c) {
        m_controlBar.add(c);
    }
}
