/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.rebop;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

/**
 * Represents a "run" of text with a single set of
 * style attributes. Does NOT perform word-wrapping
 * calculations (in other words they have already
 * been performed, resulting in a collection of these
 * WrappedRun objects).
 *
 * @author Gavin Doughtie
 * @see StyledText
 */
public class WrappedRun extends FormattedText {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/WrappedRun.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private int m_x = 0;
    private int m_y = 0;

    /**
     * Creates a new <code>WrappedRun</code> instance.
     *
     * @param font Text will be drawn using this font, or
     * the current font of the passed-in Graphics object if
     * font is set to null.
     * @param color Text will be drawn in this color, or
     * the current color of the passed-in Graphics object if
     * color is set to null.
     * @param string Text to draw
     * @param x horizontal location to begin drawing text at
     * @param y vertical location to begin drawing text at
     */
    public WrappedRun(Font font, Color color, String string, int x, int y) {
        super(font, color, string);
        setPoint(x, y);
    }

    /**
     * Draw the text using this run's font and color
     * @param g Graphics to draw upon
     */
    public void draw(Graphics g) {
        updateGraphics(g);
        g.drawString(getString(), m_x, m_y);
    }

    /**
     * Sets the point at which this run of text will be drawn
     * inside the current component's coordinate space.
     * @param x horizontal location
     * @param y vertical location
     */
    public void setPoint(int x, int y) {
        m_x = x;
        m_y = y;
    }
}// WrappedRun
