/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox;

import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.ParameterProvider;
import com.arsdigita.util.Assert;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * Provides a character set encoding parameter to add to each URL or Form in a
 * request.
 * </p>
 *
 * @version $Revision: #11 $ $Date: 2004/04/07 $
 */
public class CharsetEncodingProvider implements ParameterProvider {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/CharsetEncodingProvider.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static StringParameter s_encodingParam =
        new StringParameter(Globalization.ENCODING_PARAM_NAME);

    private static Set s_models = new HashSet();

    static {
        s_encodingParam.setDefaultValue(Globalization.DEFAULT_ENCODING);
        s_encodingParam.setDefaultOverridesNull(true);
        s_models.add(s_encodingParam);
    }

    public Set getModels() {
        return Collections.unmodifiableSet(s_models);
    }

    public Set getParams(HttpServletRequest request) {
        Set params = new HashSet();

        Locale locale = Kernel.getContext().getLocale();
        
        Assert.assertNotNull(locale, "Locale locale");

        ParameterData pd = new ParameterData
            (s_encodingParam, Globalization.getDefaultCharset(locale));

        params.add(pd);

        return Collections.unmodifiableSet(params);
    }
}
