/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.html;

import com.arsdigita.templating.html.AttributeMap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.xml.sax.Attributes;

/**
 * An implementation of the {@link AttributeMap} interface.
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2002-08-29
 * @version $Id: //core-platform/dev/src/com/arsdigita/templating/html/AttributeMapImpl.java#4 $
 **/
public final class AttributeMapImpl implements AttributeMap {

    private Map m_map;

    public AttributeMapImpl() {
        m_map = new HashMap();
    }

    public AttributeMapImpl(Attributes attrs) {
        this();
        for (int i=0; i<attrs.getLength(); i++) {
            putValue(attrs.getQName(i), attrs.getValue(i));
        }
    }

    public boolean contains(String qName) {
        return m_map.containsKey(qName);
    }

    public String getValue(String qName) {
        return (String) m_map.get(qName);
    }

    public void putValue(String qName, String value) {
        m_map.put(qName, value);
    }

    public int size() {
        return m_map.size();
    }

    public Iterator keys() {
        return m_map.keySet().iterator();
    }

    public Iterator pairs() {
        List list = new ArrayList();
        for (Iterator i=m_map.entrySet().iterator(); i.hasNext(); ) {
            Map.Entry entry = (Map.Entry) i.next();

            AttributeMap.Pair pair = new PairImpl((String) entry.getValue(),
                                                  (String) entry.getKey());
            list.add(pair);
        }
        return list.iterator();
    }
}
