/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.SingletonParameter;
import com.arsdigita.util.parameter.StringParameter;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross
 */
public final class TemplatingConfig extends AbstractConfig {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/templating/TemplatingConfig.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (TemplatingConfig.class);

    private final Parameter m_paths;
    private final Parameter m_resolver;

    public TemplatingConfig() {
        m_paths = new StringParameter
            ("waf.templating.stylesheet_paths", Parameter.REQUIRED,
             "/WEB-INF/resources/stylesheet-paths.txt");

        m_resolver = new SingletonParameter
            ("waf.templating.stylesheet_resolver", Parameter.REQUIRED,
             new PatternStylesheetResolver());

        register(m_paths);
        register(m_resolver);

        loadInfo();
    }

    final String getStylesheetPaths() {
        return (String) get(m_paths);
    }

    /**
     * Gets the stylesheet resolver.  This value is set via the
     * <code>com.arsdigita.templating.stylesheet_resolver</code>
     * system property.
     */
    public final StylesheetResolver getStylesheetResolver() {
        return (StylesheetResolver) get(m_resolver);
    }
}
