/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.ui.filters;

import java.util.Date;

public class DateRange {

    
    private Date m_start;
    private Date m_end;
    
    public DateRange(Date start,
                     Date end) {
        m_start = start;
        m_end = end;
    }
    
    public DateRange(String encoded) {
        int offset = encoded.indexOf(":");
        m_start = new Date(encoded.substring(0, offset));
        m_end = new Date(encoded.substring(offset+1));
    }
    
    public Date getStartDate() {
        return m_start;
    }
    
    public Date getEndDate() {
        return m_end;
    }

    public String toString() {
        return m_start.toString() + ":" + m_end.toString();
    }
}
