/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.ui;

import com.arsdigita.search.Search;
import com.arsdigita.search.FilterType;

import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;

import org.apache.log4j.Logger;

/**
 * This class provides a base for filter components
 * which don't have any form state parameters.
 * 
 * @see com.arsdigita.search.ui.FilterGenerator
 */
public abstract class FilterComponent extends SimpleComponent 
    implements FilterGenerator {

    private static final Logger s_log = 
        Logger.getLogger(FilterComponent.class);
    
    private FilterType m_type;
    
    /**
     * Creates a filter component
     * @param type the filter type
     * @param name the state parameter name
     */
    public FilterComponent(FilterType type) {
        m_type = type;
        
        setAttribute("type", m_type.getKey());
    }

    public void generateXML(PageState state,
                            Element parent) {
        Element content = Search.newElement("filter");
        exportAttributes(content);

        generateBodyXML(state, content);

        parent.addContent(content);
    }

    /**
     * THis method must generate the body of the component,
     * typically a list of possible values for the filter
     */
    protected abstract void generateBodyXML(PageState state,
                                            Element parent);
    
}
