/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;

import java.io.IOException;
import java.util.BitSet;
/**
 *
 * ObjectTypeFilter
 *
 * @author Richard Su (richard.su@alum.mit.edu)
 * @version $Id: //core-platform/dev/src/com/arsdigita/search/lucene/ObjectTypeFilter.java#3 $
 *
 **/

public class ObjectTypeFilter extends Filter {

    private String m_objectType;

    /**
     * Creates a new ObjectTypeFilter
     *
     * @param objectType the object type to filter on
     *
     **/
    public ObjectTypeFilter(String objectType) {
        m_objectType = objectType;
    }

    /**
     * Returns a BitSet with true for documents which
     * should be permitted in search results, and false
     * for those that should not.
     **/
    final public BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        TermDocs enum = reader.termDocs(new Term(Document.TYPE, m_objectType));

        while (enum.next()) {
            bits.set(enum.doc());
        }

        return bits;
    }

}
