/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

/**
 *
 * LuceneLock is intended to be a lock/mutex to control access to the
 * Lucene index resource. LuceneSearch and LuceneSearchableObserver
 * should synchronize against LuceneLock prior to reading or writing
 * to the Lucene index.
 *
 * LuceneLock is necessary because Lucene is not thread safe and does
 * not allow the index to be modified when performing an ongoing
 * search.
 * @see <a
 * href="http://www.lucene.com/cgi-bin/faq/faqmanager.cgi?file=chapter.search&toc=faq#q41">http://www.lucene.com/cgi-bin/faq/faqmanager.cgi?file=chapter.search&toc=faq#q41</a>
 *
 * @author Richard Su (richard.su@alum.mit.edu)
 * @version $Id: //core-platform/dev/src/com/arsdigita/search/lucene/LuceneLock.java#3 $
 *
 **/
class LuceneLock {

    private static final LuceneLock INSTANCE = new LuceneLock();

    //
    // Singleton Class
    private LuceneLock() {}

    public static LuceneLock getInstance() {
        return INSTANCE;
    }

}
