/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.util.Assert;
import java.util.Timer;

import org.apache.log4j.Logger;

/**
 * Index
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/

class Index {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/lucene/Index.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(Index.class);

    private static String s_location;
    private static final Timer TIMER = new Timer(true);

    private static Integer s_id;

    synchronized static int getIndexID() {
        if ( s_id == null ) {
            s_id = IndexId.retrieveIndexID();
            if ( s_id == null ) {
                throw new IllegalStateException
                    ("lucene index id has not been initialized");
            }
        }

        return s_id.intValue();
    }

    static void setLocation(String location) {
        s_location = location;
    }

    public static final String getLocation() {
        return s_location;
    }

    public static final Timer getTimer() {
        return TIMER;
    }

}
