/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.persistence.metadata.ObjectType;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

/**
 * Adapter.
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 **/

public abstract class Adapter {

    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/search/lucene/Adapter.java#3 $" +
        " by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    /**
     * Gets the ID for the DomainObject
     *
     * @param dobj
     * @return ID of the object
     *
     * @post $retval != null
     */
    public abstract BigDecimal getID(DomainObject dobj);

    public abstract ObjectType getObjectType(DomainObject dobj);

    public abstract String getTypeSpecificInfo(DomainObject dobj);

    public abstract Locale getLocale(DomainObject dobj);

    /**
     * Gets the Title property for the DomainObject
     *
     * @param dobj
     * @return title of the object
     *
     * @post $retval != null
     */
    public abstract String getTitle(DomainObject dobj);

    public abstract String getSummary(DomainObject dobj);

    public abstract String getContent(DomainObject dobj);

    public abstract Date getCreationDate(DomainObject dobj);

    public abstract Party getCreationParty(DomainObject dobj);

    public abstract Date getLastModifiedDate(DomainObject dobj);

    public abstract Party getLastModifiedParty(DomainObject dobj);

}
