/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;

/**
 * SyncInitializer
 *
 * Forces a sync of the database.
 * Should be run as the last initializer, so that initial
 * setup data will immediately be available to search.
 * Presently has no configuration available, either it runs
 * or it doesn't.
 *
 * @author David Eison
 * @version $Revision: #3 $ */

// Support for Logging.
import org.apache.log4j.Logger;

public class SyncInitializer
    implements com.arsdigita.initializer.Initializer {

    private Configuration m_conf = new Configuration();

    private static final Logger s_log =
        Logger.getLogger(Initializer.class);

    public final static String versionId = "$Id";

    public SyncInitializer() throws InitializationException {
    }

    /**
     * Returns the configuration object used by this initializer.
     **/
    public Configuration getConfiguration() {
        return m_conf;
    }

    /**
     * Called on startup.  Forces a sync.
     **/
    public void startup() {

        TransactionContext txn = SessionManager.getSession()
            .getTransactionContext();
        txn.beginTxn();
        BuildIndex.forceSyncNow();
        txn.commitTxn();
    }

    /**
     * Called on shutdown.  No-op.
     **/
    public void shutdown() {
    }
}
