/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.search.Search;
import org.apache.log4j.Logger;


/**
 * This class is deprecated since it is Intermedia specific.
 * All code should now be using the generic search API found
 * in the com.arsdigita.search package.
 * @deprecated register a com.arsdigita.search.MetadataProvider instead
 **/

public abstract class SearchableACSObject extends ACSObject implements Searchable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/SearchableACSObject.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected void initialize() {
        super.initialize();
        if (Search.getConfig().isIntermediaEnabled()) {
            addObserver(new SearchableObserver(this));
        }
    }

    private static final Logger s_log =
        Logger.getLogger( SearchableACSObject.class.getName() );


    /**
     ** CONSTRUCTORS so that we are compatible with ACSObject
     **/
    public SearchableACSObject(DataObject SearchableACSObjectData) {
        super(SearchableACSObjectData);
    }
    public SearchableACSObject(String typeName) {
        super(typeName);
    }
    public SearchableACSObject(ObjectType type) {
        super(type);
    }
    public SearchableACSObject(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }


    /**
     ** Searchable interface methods that must be implemented by any class that
     ** extends SearchableACSObject.  These methods return the content that
     ** is indexed.
     **/

    // These could be protected, but public may make it easier to debug
    abstract public String getSearchSummary();
    abstract public String getSearchLinkText();
    abstract public String getSearchUrlStub();
    abstract public String getSearchXMLContent();
    abstract public byte[] getSearchRawContent();

    public String getSearchLanguage() {
        // Returns language type of document.  "eng" is english, (ISO 639-2)
        // If not English, should be overridden.
        return "eng";
    }
}
