/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import java.util.Iterator;

/**
 * This interface provides an API for accessing the documents
 * matching a search query in an efficient manner. It allows
 * for retrieval of a 'page' of results &amp; associated metadata
 * such as the total number of results &amp; the search duration.
 * 
 * @see com.arsdigita.search.Document
 */
public interface ResultSet {
    
    /**
     * Gets an iterator for the page of results between
     * <code>offset</code> and <code>offset+count</code>
     *
     * @param offset the first hit, starting from 0
     * @param count the maximum number of results to return
     * @return an iterator of Document objects
     * @throws java.lang.IllegalOperationException if close has been called
     */
    Iterator getDocuments(long offset,
                          long count);
    
    /**
     * Releases any resources associated with this result
     * set. This is a no-op if the result set doesn't have
     * any system resources allocated
     */
    void close();

    /**
     * Returns the total number of results in the set
     * @return the result count
     */
    long getCount();
    
    /**
     * Return the elapsed time for generating this result
     * set from the original query specification.
     * @return the query time in milliseconds
     */
    long getQueryTime();
    
    /**
     * Return the query engine used to generate the 
     * result set
     * @return the query engine
     */
    String getEngine();
}
