/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;


/**
 * This interface is the bridge between the generic 
 * application programmers API and the backend (search engine
 * specific) implementations. Instances of this this
 * interface are registered against various combinations
 * of filter type and search engine to perform the actual
 * search operation. Application programmers do not need
 * to access instances of this class directly, rather they
 * should use the <code>process</code> method in the <code>Search</code>
 * class.
 * <p>
 * The provided implementation for intermedia currently
 * allows any combination of the following filters:
 *<pre>
 * 'permissions' - filter by READ privilege
 * 'categories' - filter by category membership
 * 'types' - filter by object type
 *</pre>
 * The provided implementation for lucene currently
 * only supports the 'types' filter.
 *
 * @see com.arsdigita.search.QueryEngineRegistry
 * @see com.arsdigita.search.Search
 */
public interface QueryEngine {
    
    /**
     * Processes a query specification generating a document
     * result set
     * @param spec the query specification
     * @return the document result set
     */
    public ResultSet process(QuerySpecification spec);
}


