/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.ObjectTypeRegistry;


public class MetadataProviderRegistry {
    
    private static ObjectTypeRegistry s_registry = new ObjectTypeRegistry();
    
    /**
     * Registers an adapter against an object type
     * @param type the object type name
     * @param adapter the metadata provider implementation
     */
    public static void registerAdapter(String type,
                                       MetadataProvider adapter) {
        s_registry.registerAdapter(type, adapter);
    }
    
    /**
     * Unregisters an adapter against an object type
     * @param type the object type name
     */
    public static void unregisterAdapter(String type) {
        s_registry.unregisterAdapter(type);
    }

    /**
     * Registers an adapter against an object type
     * @param type the object type
     * @param adapter the metadata provider implementation
     */
    public static void registerAdapter(ObjectType type,
                                       MetadataProvider adapter) {
        s_registry.registerAdapter(type, adapter);
    }
    
    /**
     * Unregisters an adapter against an object type
     * @param type the object type
     */
    public static void unregisterAdapter(ObjectType type) {
        s_registry.unregisterAdapter(type);
    }
    
    /**
     * Returns the adapter registered against an object
     * type
     * @param type the object type name
     * @return the metadata provider adapter, or null
     */
    public static MetadataProvider getAdapter(String type) {
        return (MetadataProvider)s_registry.getAdapter(type);
    }

    /**
     * Returns the adapter registered against an object
     * type
     * @param type the object type
     * @return the metadata provider adapter, or null
     */
    public static MetadataProvider getAdapter(ObjectType type) {
        return (MetadataProvider)s_registry.getAdapter(type);
    }

    /**
     * Searches up  the object type hierarchy until
     * a metadata provider adapter is found
     *
     * @param type the object type name
     * @return the metadata provider adapter, or null
     */
    public static MetadataProvider findAdapter(String type) {
        return (MetadataProvider)s_registry.findAdapter(type);
    }

    /**
     * Searches up  the object type hierarchy until
     * a metadata provider adapter is found
     *
     * @param type the object type
     * @return the metadata provider adapter, or null
     */
    public static MetadataProvider findAdapter(ObjectType type) {
        return (MetadataProvider)s_registry.findAdapter(type);
    }

}
